#include	"stdThread.h"

static BOOL		gfEnableESC = FALSE;
//-----------------------------------------------------------------
// Function
//		dwNow と dwPast の間の経過を求める
// Parameter
//		なし
// Return
//		経過
//-----------------------------------------------------------------
DWORD GetdwInterval(DWORD dwNow, DWORD dwPast)
{
	DWORD	dwInterval;

	if(dwNow >= dwPast)
		dwInterval = dwNow - dwPast;
	else
		dwInterval = dwNow + ((DWORD)(-1) - dwPast);
	return(dwInterval);
}

//-----------------------------------------------------------------
// Function
//		システムタイム(msec)を取得する
// Parameter
//		なし
// Return
//		なし
//-----------------------------------------------------------------
DWORD timeGetTime()
{
	DWORD			dwTime = 0;
	struct timeval 	tv;

	if(gettimeofday(&tv, NULL) == -1) 
		goto L_END;
	dwTime = tv.tv_sec * 1000 + tv.tv_usec / 1000;
L_END:
	return(dwTime);
}


//----------------------------------------------
// function
//		Windowsのkbhitと同様の機能をターミナルの
//		モードを変更することで実現したもの
// parameter
//		なし
// return
//    0:入力なし 1:入力あり
//----------------------------------------------
int kbhit(void)
{
	struct termios oldt, newt;
	int ch;
	int oldf;

	// 現在のttyのモードを取得
	tcgetattr(STDIN_FILENO, &oldt);
	newt = oldt;
	// 大文字変換、エコーモードなしに
	newt.c_lflag &= ~(ICANON | ECHO);
	// ttyモード即時変更
	tcsetattr(STDIN_FILENO, TCSANOW, &newt);
	// アクセスモード取得
	oldf = fcntl(STDIN_FILENO, F_GETFL, 0);
	// ノンブロッキングモードに変更
	fcntl(STDIN_FILENO, F_SETFL, oldf | O_NONBLOCK);
	// 改行入力なしでも取得(入力のないときはEOF)
	ch = getchar();

	// ttyのモードを元に戻す
	tcsetattr(STDIN_FILENO, TCSANOW, &oldt);
	// アクセスモードを元に戻す
	fcntl(STDIN_FILENO, F_SETFL, oldf);

	if (ch != EOF)
	{
		// 入力された文字をストリームに戻す
		ungetc(ch, stdin);
		return 1;
	}
	return 0;
}

//----------------------------------------------
// function
//		エラーコードとエラーメッセージを表示します
// parameter
//		LPCSTR pszTitle	[in]メッセージにつけるタイトル
// return
//		エラーコード
//----------------------------------------------
int DispErrorMsg(LPCSTR pszTitle)
{
	fprintf(stderr, "%s %d %s\n", pszTitle, errno, strerror(errno));
	return(errno);
}

//----------------------------------------------------------------------
// function
//		ESCシーケンスによる画面制御を有効にする
// parameter
//		なし
// return
//		TRUE/FALSE
//----------------------------------------------------------------------
BOOL EnableESC()
{
	gfEnableESC = TRUE;

L_END:
	return(TRUE);
}


//----------------------------------------------------------------------
// function
//		ESCシーケンスによるカーソル移動
// parameter
//		int		iCol		[in]列
//		int		iRow		[in]行
//		int		iErase		[in]0:消さない 1:行末まで消す 2:最後まで消す
// return
//		TRUE/FALSE
//----------------------------------------------------------------------
void Locate(int iCol, int iRow, int iErase)
{
	if (gfEnableESC == FALSE)
		return;
	switch (iErase)
	{
	case 1:
		fprintf(stderr, "\x1b[%d;%dH\x1b[0K", iRow, iCol);
		break;
	case 2:
		fprintf(stderr, "\x1b[%d;%dH\x1b[0J", iRow, iCol);
	default:
		fprintf(stderr, "\x1b[%d;%dH", iRow, iCol);
		break;
	}
}