#pragma once
#include	"stdThread.h"

#define		MAGIC_DATA_LEN		36
#define		MAGIC_STRING		"E2E6F7BF-42B1-4382-AF0B-1F452ED13EB6"
#define		FILE_NAME_LEN		256			// t@C̒
#define		FILE_SIZE_DIGIT		10			// t@CTCY̌

// Client->Server, Server->Client
#define		CMD_MSG_DATA			100
// Client->Server
#define		CMD_SEND_FILE_START_REQ	200		// MJnv
#define		CMD_SEND_FILE_ING		201		// t@CM
#define		CMD_SEND_FILE_END_REQ	202		// Mv
#define		CMD_SEND_FILE_ABORT_REQ	203		// fv

// Server->Client
#define		CMD_SEND_FILE_START_RES	1200	// MJnvɑ΂鉞
#define		CMD_SEND_FILE_END_RES	1202	// Mvɑ΂鉞
#define		CMD_SEND_FILE_ABORT_RES	1203	// fvɑ΂鉞



#pragma pack(push ,1)
// ʃwb_
typedef struct
{
	BYTE	bMagicData[MAGIC_DATA_LEN];		// sANZXh~p(WindowsGUIDg܂)
	WORD	wCommand;						// lbg[NI[_[
	WORD	wDataLen;						// lbg[NI[_[
} HeaderRec;

// bZ[WMp\ ʃwb_ + f[^ 
typedef struct
{
	HeaderRec	header;
	BYTE		bMsgData[1];				// null^[~lCg܂܂Ȃf[^
} MsgDataRec;

//------------------------------------
// f[^ t@CMJnv
typedef struct
{
	char	szFileSize[FILE_SIZE_DIGIT + 1];	// t@C(null^[~l[g܂)
	char	szFileName[FILE_NAME_LEN + 1];		// t@C(null^[~l[g܂)UTF-8
} FileInfoRec;

typedef struct
{
	HeaderRec	header;
	FileInfoRec	FileInfo;
} SendFileStartReqRec;

//------------------------------------
// f[^ t@CM(t@C̓rAŌ)
typedef struct
{
	char	szOffset[FILE_SIZE_DIGIT + 1];		// 擪̈ʒu
	char	szSize[FILE_SIZE_DIGIT + 1];		// f[^̃TCY
} SendFileStatRec;

typedef struct
{
	HeaderRec		header;
	SendFileStatRec	Stat;
	BYTE			bData[1];
} SendFileIngRec, SendFileEndReqRec;

//------------------------------------
// f[^ t@CMfv
typedef struct
{
	HeaderRec	header;
} SendFileAbortReqRec;

//------------------------------------
// f[^ t@CMvɑ΂鉞
typedef struct
{
	HeaderRec	header;
	char		cResCode;						// 1: -1:s ȂǉeR[h
} SendFileResRec;

#pragma pack(pop)

