#include	"stdThread.h"
#include	"SendRecvThread.h"	// MXbhg
#include	"MySyncObject.h"	// IuWFNgg
#include	"define.h"
#include    <ifaddrs.h>			// 
#include    <net/if.h>			// 

#define		CMD_QUIT_CHAR	'q'	// (3)
#define		CMD_JOIN_CHAR	'+'	// (3)
#define		CMD_LEAVE_CHAR	'-'	// (3)


// ֐̐錾
BOOL CreateAndBindSocket(LPCSTR szAddress, WORD wPort);	// (4)\Pbg̍쐬ƖOt
BOOL DestroySocket(SOCKET &fd);							// \Pbg̔j		
void Stop();											// ׂẴ\Pbgj
void DispMenu();										// (3)
int	 GetKeyString(LPSTR pszString, int iSize);			// (3)

BOOL SetRecvSocketOption(SOCKET fd, int iFamily, LPSTR szPort);				// (4)
void SetMutiticastInfo(LPSTR szIFName, LPSTR szAddr, LPSTR szPort);			// (5)
sockaddr *GetInterfaceInfo(int iFamily, LPCSTR szIFName, DWORD *pdwIndex);	// (5)
BOOL MGroupControl(BOOL fJoin, SOCKET fdRecv, group_req *pmreq);			// (5)

// ϐ̐錾
SOCKET				m_fdServer;							// (1)bindςUDP\Pbg
CSendRecvThread		*m_pCSendRecvThread = NULL;			// (1)
ConnectionInfoRec	*m_pConInfo = NULL;					// (1)
CMySyncObject		*m_pCMySyncObject = NULL;			// (1)
group_req			m_mreq;								// (5)


int main(int argc, char *argv[])
{
	int		iRet = -1;
	char	szKeyInBuff[81] = {0};
	LPSTR	pszIFName = NULL;		// MC^[tF[X

//	EnableESC();					// mF邽ECSV[PXɂʐOFF
	Locate(1, 1, 2);
	m_pCMySyncObject = new CMySyncObject();
	m_pCMySyncObject->Initialize();

	// Np[^`FbN
	if ((argc != 3) && (argc != 4))
	{
		fprintf(stderr, "%s <Multicast IP> <Port> [<InterfaceName>]\n", argv[0]);
		goto L_END;
	}
	if (argc == 4)
		pszIFName = argv[3];

	// ϐ̏
	m_fdServer = INVALID_SOCKET;

	// UDP\Pbg̍쐬bind
	if (CreateAndBindSocket(argv[1], (WORD)atol(argv[2])) == FALSE)
		goto L_END;

	// }`LXgQEEp擾
	SetMutiticastInfo(pszIFName, argv[1], argv[2]);

	// MXbh̍쐬
	m_pConInfo = (ConnectionInfoRec *)calloc(1, sizeof(ConnectionInfoRec));
	m_pConInfo->pCMySyncObject = m_pCMySyncObject;
	m_pConInfo->fdClient = m_fdServer;
	m_pCSendRecvThread = new CSendRecvThread(m_pConInfo);
	m_pCSendRecvThread->Begin();

	// j[\Ə̎s
	DispMenu();
	while (1)
	{
		usleep(10 * 1000);			// usleepĂCPÛׂƂlƗǂł傤
		switch (GetKeyString(szKeyInBuff, sizeof(szKeyInBuff)))
		{
			case 0:
				break;
			case CMD_QUIT_CHAR:
				goto L_END;
				break;
			case CMD_JOIN_CHAR:
				MGroupControl(TRUE, m_fdServer, &m_mreq);
				DispMenu();
				break;
			case CMD_LEAVE_CHAR:
				MGroupControl(FALSE, m_fdServer, &m_mreq);
				DispMenu();
				break;
		}
	}
	iRet = 0;
L_END:
	// ׂẴ\Pbg̔j
	Stop();
	m_pCMySyncObject->Uninitialize();
	SAFE_DELETE(m_pCMySyncObject)
	return(iRet);
}

//----------------------------------------------
// function
//		(4)\Pbg̍쐬bind̎{
//		m_fdServerɊi[
// parameter
//		LPCSTR	szAddress	[in]}`LXgAhX
//		WORD	wPort		[in]M|[gԍ
// return
//    TRUE/FALSE
//----------------------------------------------
BOOL CreateAndBindSocket(LPCSTR szAddress, WORD wPort)
{
	BOOL		fRet = FALSE;
	SOCKET		fd = INVALID_SOCKET;
	addrinfo	hints, *pres = NULL, *pTemp = NULL;
	char		szPort[NI_MAXSERV];

	fprintf(stderr, "CreateAndBindSocket()\n");

	memset(&hints, 0, sizeof(hints));
	hints.ai_socktype = SOCK_DGRAM;
	DISABLE_C4996
	sprintf(szPort, "%d", wPort);
	ENABLE_C4996

// \Pbg(IPv4/v6)邽߂ɂ̓AhX킩Ηǂ
	if (getaddrinfo(szAddress, NULL, &hints, &pres) == 0)
	{
// Ԃpres̒Ɋi[Ăgp
		pTemp = pres;
		while (pTemp != NULL)
		{
// \Pbg쐬
			if((fd = socket(pTemp->ai_family, pTemp->ai_socktype, pTemp->ai_protocol)) == INVALID_SOCKET)
				goto L_NEXT;
			fprintf(stderr, "%d %d %d %d\n", (int)fd, pTemp->ai_family, AF_INET, AF_INET6);
// M\Pbg̐ݒ(bind)
			if (SetRecvSocketOption(fd, pTemp->ai_family, szPort) == FALSE)
			{
				DispErrorMsg("Err:SetRecvSocketOption");
				DestroySocket(fd);
				goto L_NEXT;
			}
			m_fdServer = fd;
			fRet = TRUE;
			break;
L_NEXT:
			pTemp = pTemp->ai_next;
		}
		freeaddrinfo(pres);
	}
	if (m_fdServer == INVALID_SOCKET)		// \Pbg쐬Ɏs
		fRet = FALSE;
	return(fRet);
}

//----------------------------------------------
// function
//		(4)M\Pbg̐ݒ
//		bind
// parameter
//		SOCKET		fd			[in]\Pbg
//		int			iFamily		[in]t@~
//		LPCSTR		szPort		[in]|[gԍ
// return
//		TRUE/FALSE
//----------------------------------------------
BOOL SetRecvSocketOption(SOCKET fd, int iFamily, LPSTR szPort)
{
	BOOL		fRet = FALSE;
	addrinfo	hints, *pres = NULL, *ptemp = NULL;
	int			on = 1;

#ifdef IPV6_V6ONLY
	// IPv6\PbgIPv4ˉeAhXgpȂ悤ɐݒ
	if (iFamily == AF_INET6)
	{
		on = 1;
		if (setsockopt(fd, IPPROTO_IPV6, IPV6_V6ONLY, (char *)&on, sizeof(on)) < 0)
		{
			DispErrorMsg("Err:setsockopt()");
			DestroySocket(fd);
			goto L_END;
		}
	}
#endif
// UDPłSO_REUSEADDRgȂ

// bind(|[gw肵AAhX͎w肵Ȃ(PASSIVE))
	memset(&hints, 0, sizeof(hints));
	hints.ai_socktype = SOCK_DGRAM;			// UDP
	hints.ai_family = iFamily;
	hints.ai_flags = AI_PASSIVE;
	if (getaddrinfo(NULL, szPort, &hints, &pres) != 0)
	{
		DispErrorMsg("Err:getaddrinfo()");
		goto L_END;
	}
	if (bind(fd, pres->ai_addr, (int)pres->ai_addrlen) == SOCKET_ERROR)
	{
		DispErrorMsg("Err:bind()");
		goto L_END;
	}
	fRet = TRUE;
L_END:
	if (pres != NULL)
		freeaddrinfo(pres);
	return(fRet);
}


//----------------------------------------------
// function
//    \Pbg̔j
// parameter
//    SOCKET		&fd[in/out]j\Pbg
// return
//    TRUE/FALSE
//----------------------------------------------
BOOL DestroySocket(SOCKET &fd)
{
	if (fd != INVALID_SOCKET)
	{
		fprintf(stderr, "DestroySocket()\n");
		shutdown(fd, SHUT_RDWR);     // MM~
		close(fd);
		fd = INVALID_SOCKET;
	}
	return(TRUE);
}

//----------------------------------------------
// function
//    (1)\Pbg̔jAMXbh̔j
// parameter
//    Ȃ
// return
//    Ȃ
//----------------------------------------------
void Stop()
{
	fprintf(stderr, "Stop()\n");
	//MXbh̔j, ڑς݃\Pbg̔j
	if (m_pCSendRecvThread != NULL)
	{
		m_pCSendRecvThread->End();
		m_pCSendRecvThread->WaitForEnd();
		SAFE_DELETE(m_pCSendRecvThread);

		DestroySocket(m_pConInfo->fdClient);
		SAFE_FREE(m_pConInfo)
	}
}

//----------------------------------------------
// function
//    j[̕\
// parameter
//    Ȃ
// return
//    Ȃ
//----------------------------------------------
void DispMenu()
{
	fprintf(stderr, "%c:quit %c:Join %c:Leave  : ", CMD_QUIT_CHAR, CMD_JOIN_CHAR, CMD_LEAVE_CHAR);
}

#if 0
//----------------------------------------------
// function
//    L[{[h(s܂)̎擾
//		͂ȂƂ͂Ƀ^[
// parameter
//    LPSTR		pszString	[in/out]f[^i[pobt@
//    int		iSize		[in]obt@̃TCY
// return
//    0:͂Ȃ CMD_QUIT_CHAR:I CMD_SEND_MSG_CHAR:bZ[WM
//----------------------------------------------
int GetKeyString(LPSTR pszString, int iSize)
{
	BOOL			fRet = FALSE;
	int				iRet = 0;

	if (kbhit())
	{
		switch (getchar())
		{
			case CMD_QUIT_CHAR:
				iRet = CMD_QUIT_CHAR;
				break;
			case CMD_JOIN_CHAR:
				iRet = CMD_JOIN_CHAR;
				break;
			case CMD_LEAVE_CHAR:
				iRet = CMD_LEAVE_CHAR;
				break;
			default:
				break;
		}
	}
	return(iRet);
}
#else
// [gfobOłttyȂ̂kbhit͎gȂ
// W͂0Ȃ̂select̂܂܂OKłAK̂߂poll
int GetKeyString(LPSTR pszString, int iSize)
{
	BOOL			fRet = FALSE;
	int				iRet = 0;
	pollfd			fds[1] = {0};

	fds[0].fd = 0;					// 0:W 1:Wo 2:WG[
	fds[0].events = POLLIN;			// EnterL[͂Ώۂ
	poll(fds, 1, 10);
	if (fds[0].revents & POLLIN)	// ENTERL[͂
	{
		memset(pszString, 0, iSize);
		read(0, pszString, iSize);
		switch (pszString[0])
		{
			case CMD_QUIT_CHAR:
				iRet = CMD_QUIT_CHAR;
				break;
			case CMD_JOIN_CHAR:
				iRet = CMD_JOIN_CHAR;
				break;
			case CMD_LEAVE_CHAR:
				iRet = CMD_LEAVE_CHAR;
				break;
			default:
				break;
		}
	}
	return(iRet);
}
#endif

//----------------------------------------------
// function
//		(5)}`LXgQEEp擾
//		AhXƃ|[gm_mreqɊi[
// parameter
//		LPSTR		szIFName	[in]C^[tF[X/NULL
//		LPSTR		szAddr		[in]}`LXgAhX
//		LPCSTR		szPort		[in]|[gԍ
// return
//		TRUE/FALSE
//----------------------------------------------
void SetMutiticastInfo(LPSTR szIFName, LPSTR szAddr, LPSTR szPort)
{
	sockaddr	*pAddr;
	addrinfo    hints, *pres = NULL;

	DWORD		dwIFIndex;

	memset(&m_mreq, 0, sizeof(group_req));

	memset(&hints, 0, sizeof(hints));
	hints.ai_socktype = SOCK_DGRAM;
	if (getaddrinfo(szAddr, szPort, &hints, &pres) != 0)
	{
		DispErrorMsg("Err:getaddrinfo()");
		goto L_END;
	}
	pAddr = GetInterfaceInfo(pres->ai_family, szIFName, &dwIFIndex);
	SAFE_FREE(pAddr)
	m_mreq.gr_interface = dwIFIndex;								// CfbNXi[
	memcpy(&(m_mreq.gr_group), pres->ai_addr, pres->ai_addrlen);	// AhXi[

L_END:
	if (pres != NULL)
		freeaddrinfo(pres);
	return;
}

//-----------------------------------------------------------------
// Function
//		(5)}`LXgO[v(IPv4/IPv6)
// Parameter
//		BOOL        fJoin       [in]TRUE:Q FALSE:E
//		SOCKET      fd          [in]\Pbg
//		struct group_req *pmreq [in]ΏۂƂ}`LXgO[v
// Return
//		TRUE/FALSE
//-----------------------------------------------------------------
BOOL MGroupControl(BOOL fJoin, SOCKET fdRecv, group_req *pmreq)
{
	int		iRet = -1;
	BOOL	fRet;

	if (fJoin == TRUE)
	{
		if (pmreq->gr_group.ss_family == AF_INET)
			iRet = setsockopt(fdRecv, IPPROTO_IP, MCAST_JOIN_GROUP, (char *)pmreq, sizeof(struct group_req));
		else if (pmreq->gr_group.ss_family == AF_INET6)
			iRet = setsockopt(fdRecv, IPPROTO_IPV6, MCAST_JOIN_GROUP, (char *)pmreq, sizeof(struct group_req));
	}
	else
	{
		if (pmreq->gr_group.ss_family == AF_INET)
			iRet = setsockopt(fdRecv, IPPROTO_IP, MCAST_LEAVE_GROUP, (char *)pmreq, sizeof(struct group_req));
		else if (pmreq->gr_group.ss_family == AF_INET6)
			iRet = setsockopt(fdRecv, IPPROTO_IPV6, MCAST_LEAVE_GROUP, (char *)pmreq, sizeof(struct group_req));
	}
	fRet = (iRet == 0) ? TRUE : FALSE;
	if (fRet == FALSE)
		DispErrorMsg("Err:MGroupControl");
	return(fRet);
}

//-----------------------------------------------------------------
// Function
//		w肳ꂽC^[tF[X̏擾
// Parameter
//		int		iFamily		[in]AhXt@~
//		LPCSTR	szIFName	[in]C^[tF[X
//		DWORD	*pdwIndex	[in/out]C^[tF[XCfbNX
// Return
//		w̃C^[tF[X̍ŏ̃jLXgAhX
//-----------------------------------------------------------------
sockaddr *GetInterfaceInfo(int iFamily, LPCSTR szIFName, DWORD *pdwIndex)
{
	int		iRet = 0;
	struct ifaddrs *pifaddrs = NULL, *pifa;
	char	szAddr[NI_MAXHOST], szMask[NI_MAXHOST];
	sockaddr	*pAddrRet = NULL;

	*pdwIndex = 0;
	if (szIFName == NULL)
		goto L_END;
// A_v^Xg̎擾
	if (getifaddrs(&pifaddrs) == -1)
		goto L_END;
// A_v^ꗗo
	for (pifa = pifaddrs; pifa != NULL; pifa = pifa->ifa_next)
	{
		if (pifa->ifa_addr == NULL)
			continue;
		if ((pifa->ifa_addr->sa_family != AF_INET) && (pifa->ifa_addr->sa_family != AF_INET6))
			continue;

		fprintf(stderr, "Name:%s\n", pifa->ifa_name);
// C^[tF[Xŵ̂łȂ΁A
		if (strcmp(pifa->ifa_name, szIFName) != 0)
			continue;
// t@~ŵ̂łȂΎ
		if (pifa->ifa_addr->sa_family != iFamily)
			continue;

// OCfbNX擾
		*pdwIndex = if_nametoindex(pifa->ifa_name);
		fprintf(stderr, "Index:%d\n", *pdwIndex);
		if (pifa->ifa_addr->sa_family == AF_INET)
		{
			inet_ntop(AF_INET, &((struct sockaddr_in *)pifa->ifa_addr)->sin_addr, szAddr, sizeof(szAddr));
			inet_ntop(AF_INET, &((struct sockaddr_in *)pifa->ifa_netmask)->sin_addr, szMask, sizeof(szMask));
			fprintf(stderr, "  IPv4: %s netmask %s\n", szAddr, szMask);
			pAddrRet = (sockaddr *)calloc(1, sizeof(sockaddr_in));
			memcpy(pAddrRet, pifa->ifa_addr, sizeof(sockaddr_in));
		}
		else if (pifa->ifa_addr->sa_family == AF_INET6)
		{
			inet_ntop(AF_INET6, &((struct sockaddr_in6 *)pifa->ifa_addr)->sin6_addr, szAddr, sizeof(szAddr));
			inet_ntop(AF_INET6, &((struct sockaddr_in6 *)pifa->ifa_netmask)->sin6_addr, szMask, sizeof(szMask));
			fprintf(stderr, "  IPv6: %s netmask %s\n", szAddr, szMask);
			pAddrRet = (sockaddr *)calloc(1, sizeof(sockaddr_in6));
			memcpy(pAddrRet, pifa->ifa_addr, sizeof(sockaddr_in6));
		}
// ̂Ń^[
		if (pAddrRet != NULL)
			goto L_END;
		fprintf(stderr, "\n");
	}

L_END:
	if (pifaddrs != NULL)
		freeifaddrs(pifaddrs);
	return(pAddrRet);
}
