#include "SendRecvThread.h"
#include "MySyncObject.h"		// CMySyncObjectg
#include "RingBuff.h"			// CRingBuffg

// Mx
#define		SEND_BPS	(1000000.0)	// Mx1Mbps

//----------------------------------------------
// function
//    RXgN^
// parameter
//    ConnectionInfoRec *pConInfo	[in]@\ɕKvȏ
// return
//    Ȃ
//----------------------------------------------
CSendRecvThread::CSendRecvThread(ConnectionInfoRec *pConInfo)
{
	m_pConInfo = pConInfo;
	m_fIamZombie = FALSE;
	m_pCRingBuffSend = new CRingBuff(SEND_BUFF_SIZE);	// MOobt@̍\z
	m_pCRingBuffRecv = new CRingBuff(RECV_BUFF_SIZE);	// MOobt@̍\z

	m_dwPrevSentTime = 0;								// 񑗐M͂
	m_dwSendInterval = 0;								// 
}

//----------------------------------------------
// function
//    fXgN^
// parameter
//    Ȃ
// return
//    Ȃ
//----------------------------------------------
CSendRecvThread::~CSendRecvThread()
{
	SAFE_DELETE(m_pCRingBuffSend)		// MOobt@̔j
	SAFE_DELETE(m_pCRingBuffRecv)		// MOobt@̔j
}

//----------------------------------------------
// function
//    @\Lq֐
// parameter
//    Ȃ
// return
//    0: -1:G[
//----------------------------------------------
UINT CSendRecvThread::DoWork()
{
	BOOL		fRet = TRUE;
	char	    szRecvBuffer[RCVBUFSIZE];	// Mobt@
	int			iRecvSize;
	pollfd		fds[1] = { 0 };
	char		*pcData = NULL;				// Mf[^
	int			iSendSize = 0;				// Mf[^TCY
	DWORD		dwNow;						// M`FbNo邽
	sockaddr_storage	PeerAddr;			// MAhX
	socklen_t	iPeerLen;
	char		szPeerAddr[NI_MAXHOST];		// AhX,|[gԍ
	char		szServiceNo[NI_MAXSERV];	// getnameinfoŎ擾

	fprintf(stderr, "DoWork()\n");
	fds[0].fd = m_pConInfo->fdClient;
	while (!m_fStopFlag)
	{
		// Mf[^邩Oobt@𒲂ׂ
		iSendSize = m_pCRingBuffSend->GetReadableSize();
		fds[0].events = POLLIN | POLLRDHUP;		// MƑ葤̐ؒfCxgݒ
		// `FbN̂߂Ɍݎ擾
		dwNow = timeGetTime();
		// M\Mf[^ƂM\
		if ((iSendSize > 0) && (CanSendNow(dwNow) == TRUE))
			fds[0].events |= POLLOUT;			// ݉\ǉ

		poll(fds, 1, 10);
		// ؒf̊TOȂ̂ŃG[Ȃǂł͏IȂ
		if (fds[0].revents & POLLRDHUP)			// 葤̐ؒf(͔Ȃ͂)
			fprintf(stderr, "Disconnected pollrdhup\n");
		if (fds[0].revents & POLLERR)			// G[
			DispErrorMsg("Err:DoWork");

		// M
		if (fds[0].revents & POLLIN)			// Mf[^Cxg
		{
			// UDPł̓pPbgTCY菬TCYŎMƎc͔j
			// ŎMȂ΁AreventsŎMs
			if (m_pCRingBuffRecv->GetWriteableSize() > RCVBUFSIZE)
			{
				iPeerLen = sizeof(PeerAddr);	// MAhXi[\̂̃TCY
				// recvfromł0oCg̃f[^M肤
				if ((iRecvSize = recvfrom(m_pConInfo->fdClient, szRecvBuffer, RCVBUFSIZE, 0,
					(sockaddr *)&PeerAddr, &iPeerLen)) < 0)
				{
					DispErrorMsg("Err:recvfrom");
				}
				else
				{
					// M̕\
					getnameinfo((sockaddr *)&PeerAddr, iPeerLen, szPeerAddr, NI_MAXHOST,
						szServiceNo, NI_MAXSERV, NI_NUMERICHOST | NI_NUMERICSERV);
					fprintf(stderr, "recvfrom socket:%d Addr:%s Port:%s %d\n:",
						m_pConInfo->fdClient, szPeerAddr, szServiceNo, timeGetTime() / 1000);
					// 擾f[^ɎMOobt@ɏ
					// MOobt@ɏނ̂͂̃XbhȂ̂ŁAׂď߂͂
					m_pCRingBuffRecv->Write((LPBYTE)szRecvBuffer, iRecvSize);
				}
			}
		}
		// MOobt@Ɋi[Ăf[^̉͂s
		// ̃pPbgi[Ă\̂ŁAreventšʂƂ͖֌W
		// ͂s悤ɂ
		// G[ŏIȂ
		if (AnalyzeDataRecv() == -1)
			DispErrorMsg("Err:Packet format");

		// sendtoŎw肷ׂĐǂ邩킩Ȃ̂
		// 肠ŌɎMɑԂĂ܂傤
		// M
		if (fds[0].revents & POLLOUT)		// M\Ȃsend{
		{
			// Mf[^̎擾(PATH_MTU菬Ȃ悤Ɏ擾)
			iSendSize = GetSendData(&pcData);
			if (sendto(m_pConInfo->fdClient, pcData, iSendSize, 0,
				(sockaddr *)&PeerAddr, iPeerLen) != iSendSize)
			{
				DispErrorMsg("Err:sendto");
			}
			SAFE_FREE(pcData)
			// MƎ񑗐M܂ł̎ԂZbg
			m_dwPrevSentTime = dwNow;
			m_dwSendInterval = CalcNextSendInterval(iSendSize);
		}
	}
	m_pConInfo->pCMySyncObject->Lock();
	m_fIamZombie = TRUE;
	m_pConInfo->pCMySyncObject->UnLock();
	SAFE_FREE(pcData)
	return((fRet == TRUE) ? 0 : -1);
}

//----------------------------------------------
// function
//		Mf[^̐ݒ
//		MłȂAG[ƂĐؒf̂ǂ
//		͖Ƃ
// parameter
//		char	*pcData	[in]Mf[^
//		int		iSize	[in]f[^
// return
//		TRUE/FALSE
//----------------------------------------------
BOOL CSendRecvThread::SetSendData(char *pcData, int iSize)
{
	BOOL	fRet = FALSE;

	// MOobt@ɋ󂫂ȂƂ͏܂Ȃ
	fRet = m_pCRingBuffSend->Write((LPBYTE)pcData, iSize);
	return(fRet);
}

//----------------------------------------------
// function
//		Mf[^̎擾
// parameter
//		char **ppcData	[in/out]Mf[^
// return
//		f[^
//----------------------------------------------
int CSendRecvThread::GetSendData(char **ppcData)
{
	int		iSize = 0;

	// Mf[^邩Oobt@̃f[^TCY𒲂ׂ
	if ((iSize = m_pCRingBuffSend->GetReadableSize()) > 0)
	{
		// MTCYPATH_MTU菬Ă(1024+ʃwb_Ȃv)
		iSize = min(iSize, SENDBUFSIZE);
		*ppcData = (char *)calloc(iSize, sizeof(char));
		iSize = m_pCRingBuffSend->Read((LPBYTE)*ppcData, iSize);
	}
	return(iSize);
}


//----------------------------------------------
// function
//    ̃Xbh̓]rԂ
//	  ʃXbhQƂ
// parameter
//    Ȃ
// return
//    0: -1:G[
//----------------------------------------------
BOOL CSendRecvThread::IsZombie()
{
	BOOL	fRet;

	m_pConInfo->pCMySyncObject->Lock();
	fRet = m_fIamZombie;
	m_pConInfo->pCMySyncObject->UnLock();
	return(fRet);
}

//----------------------------------------------
// function
//		Mf[^̉
//		MOobt@Ɋi[Ăf[^𒲂ׂ
// parameter
//		Ȃ
// return
//		0:pPbgĂȂ
//		1:pPbgM̂ŏs
//		-1:G[
//----------------------------------------------
BOOL CSendRecvThread::AnalyzeDataRecv()
{
	int			iRet = 0;
	HeaderRec	Header;
	WORD		wCmd;
	// f[^TCY𒲂ׂ
	int			iSize = m_pCRingBuffRecv->GetReadableSize();

	if (iSize < sizeof(HeaderRec))			// wb_TCYɖȂƂ͉Ȃ
		goto L_END;

	// wb_؂ǂݍ݂
	m_pCRingBuffRecv->ReadWithoutUpdateHeadPoint((LPBYTE)&Header, sizeof(HeaderRec));
	// wb_̉
	if (memcmp(Header.bMagicData, MAGIC_STRING, strlen(MAGIC_STRING)) != 0)
	{
		iRet = -1;							// ʎqႤ̂ŃG[
		goto L_END;
	}
	wCmd = ntohs(Header.wCommand);
	Locate(1, 10, 1);
	fprintf(stderr, "CMD:%d", wCmd);

	switch (wCmd)
	{
		case CMD_MSG_DATA:
			iRet = RecvMessagePacket(&Header);
			break;
		default:						// mȂR}h
			iRet = -1;
			break;
	}
L_END:
	return(iRet);
}

//----------------------------------------------
// function
//		bZ[WR}h̎M
// parameter
//		HeaderRec *pHeader	[in]ǂ݂wb_
// return
//		0:pPbgĂȂ
//		1:pPbgM̂ŏs
//		-1:G[
//----------------------------------------------
BOOL CSendRecvThread::RecvMessagePacket(HeaderRec *pHeader)
{
	int			iRet = 0;
	MsgDataRec	*pMsgData;
	int			iMsgSize, iSize;
	char		*pszMsg = NULL;

	iMsgSize = ntohs(pHeader->wDataLen);
	// f[^ȂƂ͉Ȃ
	iSize = m_pCRingBuffRecv->GetReadableSize();
	if (iSize < iMsgSize + sizeof(HeaderRec))
		goto L_END;
	// pPbgŜMĂ̂œǂݍ݂{
	pMsgData = (MsgDataRec *)calloc(iMsgSize + sizeof(HeaderRec), sizeof(BYTE));
	m_pCRingBuffRecv->Read((LPBYTE)pMsgData, iMsgSize + sizeof(HeaderRec));
	// NULL^[~l[gǉĊm
	pszMsg = (char *)calloc(iMsgSize + 1, sizeof(char));
	memcpy(pszMsg, pMsgData->bMsgData, iMsgSize);

	// M̂߂ɃbZ[Wf[^pPbgăZbg
	// Nɑ邩̓^C~O
	//SendMessagePacket(pszMsg, iMsgSize);

	m_pConInfo->pCMySyncObject->Lock();
	fprintf(stderr, "Msg:recv %s\n", pszMsg);
	m_pConInfo->pCMySyncObject->UnLock();

	SAFE_FREE(pMsgData)
	SAFE_FREE(pszMsg)
	iRet = 1;
L_END:
	return(iRet);
}

//----------------------------------------------
// function
//		bZ[WpPbg̑M
//		MOobt@Ɋi[
// parameter
//		char	*pcData		[in]UTF-8f[^(NULL^[~l[gȂ)
//		int		iSize		[in]f[^TCY
// retun
//		Ȃ
//----------------------------------------------
BOOL CSendRecvThread::SendMessagePacket(char *pcData, int iSize)
{
	MsgDataRec	*pMsgData = NULL;
	int			iPacketSize = sizeof(HeaderRec) + iSize;		// pPbgTCY
	BOOL		fRet = FALSE;

	pMsgData = (MsgDataRec *)calloc(iPacketSize, sizeof(BYTE));	// pPbgŜ̃GAm

	memcpy(pMsgData->header.bMagicData, MAGIC_STRING, strlen(MAGIC_STRING));
	pMsgData->header.wCommand = htons(CMD_MSG_DATA);
	pMsgData->header.wDataLen = htons(iSize);

	memcpy(pMsgData->bMsgData, pcData, iSize);
	// M̂߂ɃbZ[WpPbgf[^Zbg
	fRet = SetSendData((char *)pMsgData, iPacketSize);

	SAFE_FREE(pMsgData)
	return(fRet);
}


//----------------------------------------------
// function
//		̑M܂ł̊Ԋu(msec)߂
// parameter
//		int iSentSize [in]MTCY
// return
//		msec
//----------------------------------------------
DWORD CSendRecvThread::CalcNextSendInterval(int iSentSize)
{
	DWORD	dwInterval = 0;
	double	dbBytePerSec = SEND_BPS / 8.0;
	double	dbCountPerSec;

	if (iSentSize == 0)
		goto L_END;
	dbCountPerSec = dbBytePerSec / (double)iSentSize;
	dwInterval = DWORD(1000.0 / dbCountPerSec);

L_END:
	return(dwInterval);
}


//----------------------------------------------
// function
//		M\
// parameter
//		DWORD dwNow		[in]ݎ
// return
//		TRUE/FALSE
//----------------------------------------------
BOOL CSendRecvThread::CanSendNow(DWORD dwNow)
{
	BOOL	fRet = FALSE;

	if (GetdwInterval(dwNow, m_dwPrevSentTime) >= m_dwSendInterval)
		fRet = TRUE;

	return(fRet);
}
