#include	"RingBuff.h"

//--------------------------------------------------------
// Function
//	NX̍\zAobt@̍őTCYw
// Parameter
//	long	lMaxSize	[in]i[\ȍőTCY	
// Return
//	Ȃ
//--------------------------------------------------------
CRingBuff::CRingBuff(long lMaxSize)
{
	m_fInitialized = FALSE;
	m_pbData = NULL;
	m_lMaxSize = lMaxSize;					// TCYo
	m_lAllocSize = m_lMaxSize + 1;			// mۂTCY
	m_lHead = 0;							// ǂݍ݊Jnʒu
	m_lTail = 0;							// ݊Jnʒu
	m_pCMySyncObject = new CMySyncObject();
	m_pCMySyncObject->Initialize();

	if (lMaxSize > 0)
		m_pbData = (LPBYTE)calloc(m_lAllocSize, sizeof(BYTE));
	if (m_pbData != NULL)
		m_fInitialized = TRUE;
}

//--------------------------------------------------------
// Function
//	NX̔jAobt@̊J
// Parameter
//	Ȃ
// Return
//	Ȃ
//--------------------------------------------------------
CRingBuff::~CRingBuff(void)
{
	SAFE_FREE(m_pbData)
	m_pCMySyncObject->Uninitialize();
	SAFE_DELETE(m_pCMySyncObject)
	m_fInitialized = FALSE;
}

//-------------------------------------------------------------------------
// Function
//		f[^̓ǂݍ
//		݂̓ǂݍ݊Jnʒuǂݍ
// Parameter
//		LPBYTE	pbBuf	[in/out]obt@
//		long	lSize	[in]obt@TCY
// Return
//		ۂɓǂݍ񂾃TCY <= obt@TCY
//-------------------------------------------------------------------------
long CRingBuff::Read(LPBYTE pbBuf, long lSize)
{
	long	lReadSize = 0;
	long	ii;

// ǂݍ݉\TCY(i[Ăf[^)
// ȏ͓ǂݍ܂Ȃ悤ɂ
	m_pCMySyncObject->Lock();
	lReadSize = min(GetReadableSize0(), lSize);

	for (ii = 0; ii < lReadSize; ++ii)
	{
		pbBuf[ii] = m_pbData[m_lHead++];	// ǂݍ݈ʒuXV
		m_lHead = m_lHead % m_lAllocSize;
	}
	m_pCMySyncObject->UnLock();
	return(lReadSize);
}

//-------------------------------------------------------------------------
// Function
//		f[^̉ǂݍ
//		݂̓ǂݍ݊Jnʒuǂݍ
//		ǂݍ݈ʒu̍XVȂ
// Parameter
//		LPBYTE	pbBuf		[in/out]obt@
//		long	lSize		[in]obt@TCY
// Return
//		ۂɓǂݍ񂾃TCY
//-------------------------------------------------------------------------
long CRingBuff::ReadWithoutUpdateHeadPoint(LPBYTE pbBuf, long lSize)
{
	long	lReadSize = 0;
	long	lHead, ii;

	// ǂݍ݉\TCY(i[Ăf[^)
	// ȏ͓ǂݍ܂Ȃ悤ɂ
	m_pCMySyncObject->Lock();
	lReadSize = min(GetReadableSize0(), lSize);

	lHead = m_lHead;
	for (ii = 0; ii < lReadSize; ++ii)
	{
		pbBuf[ii] = m_pbData[lHead++];	// ǂݍ݈ʒu͍XVĂȂ
		lHead = lHead % m_lAllocSize;
	}
	m_pCMySyncObject->UnLock();
	return(lReadSize);
}

//-------------------------------------------------------------------------
// Function
//		ǂݍ݈ʒu̍XV(woCgǂ񂾂Ƃɂ)
// Parameter
//		long	lSize	[in]ǂ񂾂ƂɂoCg
// Return
//		Ȃ
//-------------------------------------------------------------------------
void CRingBuff::UpdateHeadPoint(long lSize)
{
	m_pCMySyncObject->Lock();
	m_lHead = (m_lHead + lSize) % m_lAllocSize;
	m_pCMySyncObject->UnLock();
}

//-------------------------------------------------------------------------
// Function
//		f[^̏
//		݂̏݊Jnʒu珑
//		̊֐ĂԑOGetWriteableSizeŏ݉\TCY
//		ׂ邱
// Parameter
//		LPBYTE	pbBuf		[in]obt@
//		long	lSize		[in]obt@TCY
// Return
//		TRUE:ݐ FALSE:󂫕s
//-------------------------------------------------------------------------
BOOL CRingBuff::Write(LPBYTE pbBuf, long lSize)
{
	BOOL    fRet = FALSE;
	long    ii;

	// ݉\TCY(obt@̋)擾߂邩ׂ
	m_pCMySyncObject->Lock();
	if (lSize > GetWriteableSize0())
		goto L_END;

	for (ii = 0; ii < lSize; ++ii)
	{
		m_pbData[m_lTail++] = pbBuf[ii];
		m_lTail = m_lTail % m_lAllocSize;
	}
	fRet = TRUE;
L_END:
	m_pCMySyncObject->UnLock();
	return(fRet);
}

//-------------------------------------------------------------------------
// Function
//		ǂݍ݉\TCY(i[Ăf[^)̎擾
// Parameter
//		Ȃ
// Return
//		ǂݍ݉\TCY
//-------------------------------------------------------------------------
long CRingBuff::GetReadableSize()
{
	long	lHead, lTail, lReadable = 0;

	m_pCMySyncObject->Lock();
	if (m_pbData == NULL)
		goto L_END;

	lHead = m_lHead;
	lTail = m_lTail;
	lReadable = (lHead <= lTail) ? (lTail - lHead) : (m_lAllocSize - lHead) + lTail;

L_END:
	m_pCMySyncObject->UnLock();
	return(lReadable);
}

//-------------------------------------------------------------------------
// Function
//		ǂݍ݉\TCY(i[Ăf[^)̎擾
//		Ȃ
// Parameter
//		Ȃ
// Return
//		ǂݍ݉\TCY
//-------------------------------------------------------------------------
long CRingBuff::GetReadableSize0()
{
	long	lHead, lTail, lReadable = 0;

	if (m_pbData == NULL)
		goto L_END;

	lHead = m_lHead;
	lTail = m_lTail;
	lReadable = (lHead <= lTail) ? (lTail - lHead) : (m_lAllocSize - lHead) + lTail;

L_END:
	return(lReadable);
}

//-------------------------------------------------------------------------
// Function
//		݉\TCY(󂫃TCY)̎擾
// Parameter
//		Ȃ
// Return
//		݉\TCY
//-------------------------------------------------------------------------
long CRingBuff::GetWriteableSize()
{
	long	lHead, lTail, lWritable = 0;

	m_pCMySyncObject->Lock();
	if (m_pbData == NULL)
		goto L_END;

	lTail = m_lTail;
	lHead = m_lHead;
	lWritable = (lTail < lHead) ? (lHead - lTail) : (m_lAllocSize - lTail) + lHead;

	if (lWritable > 0)			// HaedTail̊ԂɌԂJ邽1oCg炷
		--lWritable;
L_END:
	m_pCMySyncObject->UnLock();
	return(lWritable);
}

//-------------------------------------------------------------------------
// Function
//		݉\TCY(󂫃TCY)̎擾
//		Ȃ
// Parameter
//		Ȃ
// Return
//		݉\TCY
//-------------------------------------------------------------------------
long CRingBuff::GetWriteableSize0()
{
	long	lHead, lTail, lWritable = 0;

	if (m_pbData == NULL)
		goto L_END;

	lTail = m_lTail;
	lHead = m_lHead;
	lWritable = (lTail < lHead) ? (lHead - lTail) : (m_lAllocSize - lTail) + lHead;

	if (lWritable > 0)			// HaedTail̊ԂɌԂJ邽1oCg炷
		--lWritable;
L_END:
	return(lWritable);
}

//-------------------------------------------------------------------------
// Function
//		݁Aǂݍ݃|C^̏
// Parameter
//		Ȃ
// Return
//		Ȃ
//-------------------------------------------------------------------------
void CRingBuff::Clear()
{
	m_pCMySyncObject->Lock();
	m_lTail = 0;
	m_lHead = 0;
	m_pCMySyncObject->UnLock();
}

